

/* Pocket Smalltalk
   Copyright (c) 1998,1999 by Andrew Brault
   http://www.pocketsmalltalk.com
   See LICENSE.TXT for license information */

/* Math primitives and functions. */


Object p_integer_add(Object arg);
Object p_integer_subtract(Object arg);
Object p_integer_multiply(Object arg);
Object p_integer_bitand(Object arg);
Object p_integer_bitor(Object arg);
Object p_integer_bitxor(Object arg);
Object p_integer_truncate_div(Object arg);
Object p_integer_quo_div(Object arg);
Object p_integer_gcd(Object arg);
Object p_integer_less(Object arg);
Object p_integer_lesseq(Object arg);
Object p_integer_greater(Object arg);
Object p_integer_greatereq(Object arg);
Object p_integer_equal(Object arg);
Object p_integer_notequal(Object arg);
Object p_integer_rem(Object arg);
Object p_integer_mod(Object arg);
Object p_integer_bitshift(Object arg);
Object p_integer_print_string(void);

#define IS_SMALLTALK_DOUBLE(object)  (CLASS_OF(object) == Double)
double from_smalltalk_double(Object object);
Object as_smalltalk_double(double value);
Object double_binary_op(Object left, Object right, long op);

Object p_double_print_string(void);
Object p_double_as_integer(void);
Object p_integer_as_double(void);
Object p_double_add(Object arg);
Object p_double_subtract(Object arg);
Object p_double_multiply(Object arg);
Object p_double_divide(Object arg);
Object p_double_less(Object arg);
Object p_double_unary_function(Object findex);
Object p_double_remainder(Object arg);

boolean is_integer(Object object);
Object integer_compare(Object left, Object right, char op);
Object integer_op(Object left, Object right, char op);
Object as_smalltalk_integer(int32 value);
int32 as_c_integer(Object object);
